unit artlcd;

interface

uses
  SysUtils, Classes, windows;

type

 EArtLCDException = class(Exception)
 end;

 TCharBitmap = array[0..7] of char;
 TCustomChars = array[0..7] of char;

 pDISPLAYDLL_Init = procedure (const x_size : byte; const y_size : byte; const startparam :pchar; ok : pbool); stdcall;
 pDISPLAYDLL_DriverName = function():pchar;stdcall;
 pDISPLAYDLL_Usage = function():pchar;stdcall;
 pDISPLAYDLL_DefaultParameters= function():pchar;stdcall;
 pDISPLAYDLL_Done = procedure() ; stdcall;
 pDISPLAYDLL_SetBacklight = procedure(const on : boolean); stdcall;
 pDISPLAYDLL_SetContrast = procedure(const val:byte); stdcall;
 pDISPLAYDLL_SetBrightness = procedure(const val:byte); stdcall;
 pDISPLAYDLL_Write = procedure(const str : pchar); stdcall;
 pDISPLAYDLL_SetPosition = procedure(const x:byte; const y:byte); stdcall;
 pDISPLAYDLL_CustomChar = procedure(const ascii:byte; bitmap : TCharBitmap); stdcall;
 pDISPLAYDLL_ReadKey = function() : word; stdcall;
 pDISPLAYDLL_SetGPO = procedure(GPO : byte; GPOOn : boolean); stdcall;
 pDISPLAYDLL_SetFan = procedure(T1,T2 : byte); stdcall;
 pDISPLAYDLL_CustomCharIndex= function(Index : byte) : byte; stdcall;

   TArtLCD = class(TComponent)
  private
   pInit: pDISPLAYDLL_Init;
   pDriverName : pDISPLAYDLL_DriverName;
   pUsage : pDISPLAYDLL_Usage;
   pDefaultParameters : pDISPLAYDLL_DefaultParameters;
   pDone : pDISPLAYDLL_Done;
   pSetBacklight : pDISPLAYDLL_SetBacklight;
   pSetContrast : pDISPLAYDLL_SetContrast;
   pSetBrightness : pDISPLAYDLL_SetBrightness;
   pWrite : pDISPLAYDLL_Write;
   pSetPosition : pDISPLAYDLL_SetPosition;
   pCustomChar : pDISPLAYDLL_CustomChar;
   pReadKey : pDISPLAYDLL_ReadKey;
   pSetGPO : pDISPLAYDLL_SetGPO;
   pSetFan : pDISPLAYDLL_SetFan;
   pCustomCharIndex : pDISPLAYDLL_CustomCharIndex;
   fDllName : string;
   fcustomchar : TCustomChars;
   fDrivername, fUsage, fDefaultParameters : string;
   fBackLight : boolean;
   fContrast, fBrightness : byte;
   fposx, fposy, fsizex, fsizey : integer;
   fdllh : THandle;
   fparam : string;
   finit : boolean;
  protected

  public

   constructor Create(AOwner: TComponent); override;

   procedure SetDLL(Dname : string);
   procedure Done;
   procedure SetBacklight(b:boolean);
   procedure SetContrast(b:byte);
   procedure SetBrightness(b:byte);
   procedure Write(s:string);
   procedure WriteXY(x,y:byte;s:string);
   procedure SetPosition(x,y:integer);
   procedure SetCustomChar(const char:byte; bitmap : TCharBitmap);
   function  ReadKey : char;
   procedure SetGPO(GPO : byte; GPOOn : boolean);
   procedure SetFan(T1,T2 : byte);

   procedure SetPosX(x:integer);
   procedure SetPosY(y:integer);
   function Init : boolean;


   property DriverName : string read fDriverName;
   property Usage : string read fUsage;
   property DefaultParameters : string read fDefaultParameters;
   property CustomChar : TCustomChars read fcustomchar;

  published
   property DLLName : string read fDllName write SetDLL;
   property SizeX : integer read fsizex write fsizex;
   property SizeY : integer read fsizey write fsizey;
   property StartParam : string read fparam write fparam;
   property PosX : integer read fposx write setposx default 0;
   property PosY : integer read fposy write setposy  default 0;
   property Contrast : byte read fContrast write SetContrast default 128;
   property Brightness : byte read fBrightness write SetBrightness default 128;
   property BackLight : boolean read fBackLight write SetBacklight default true;
  end;

procedure Register;

implementation

const
 DefCustomChar : array [0..7] of char = (#176,#158,#131,#132,#133,#134,#135,#136);

procedure TArtLCD.SetDLL(Dname : string);
begin
  if fDLLName = Dname then exit;
  finit := false;
  if not fileexists(dname) then Raise EArtLCDException.Create('Could not find dll file "'+Dname+'"');

  fdllh := LoadLibrary(pchar(DName));
  if fdllh<>0 then
  begin
   pInit := GetProcAddress(fdllh, 'DISPLAYDLL_Init');
   pDriverName := GetProcAddress(fdllh, 'DISPLAYDLL_DriverName');
   pUsage := GetProcAddress(fdllh, 'DISPLAYDLL_Usage');
   pDefaultParameters := GetProcAddress(fdllh, 'DISPLAYDLL_DefaultParameters');
   pDone := GetProcAddress(fdllh, 'DISPLAYDLL_Done');
   pSetBacklight := GetProcAddress(fdllh, 'DISPLAYDLL_SetBacklight');
   pSetContrast := GetProcAddress(fdllh, 'DISPLAYDLL_SetContrast');
   pSetBrightness := GetProcAddress(fdllh, 'DISPLAYDLL_SetBrightness');
   pWrite := GetProcAddress(fdllh, 'DISPLAYDLL_Write');
   pSetPosition := GetProcAddress(fdllh, 'DISPLAYDLL_SetPosition');
   pCustomChar := GetProcAddress(fdllh, 'DISPLAYDLL_CustomChar');
   pReadKey := GetProcAddress(fdllh, 'DISPLAYDLL_ReadKey');
   pSetGPO := GetProcAddress(fdllh, 'DISPLAYDLL_SetGPO');
   pSetFan := GetProcAddress(fdllh, 'DISPLAYDLL_SetFan');
   pCustomCharIndex := GetProcAddress(fdllh, 'DISPLAYDLL_CustomCharIndex');

   if (@pInit = nil) or (@pWrite = nil) or (@pSetPosition = nil) then
    Raise EArtLCDException.Create('Wrong dll file "'+Dname+'"');

   if (@pDriverName = nil) then fDrivername := ''
   else fDrivername := pDriverName;

   if (@pUsage = nil) then fUsage := ''
   else fUsage := pUsage;

   if (@pDefaultParameters = nil) then fDefaultParameters := ''
   else fDefaultParameters := pDefaultParameters;

  end
  else
   Raise EArtLCDException.Create('Could not load dll "'+Dname+'"');
end;

constructor TArtLCD.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fcontrast := 128;
  fbrightness := 128;
  fbacklight:= true;
  fposx := 0;
  fposy := 0;
end;


function TArtLCD.Init:boolean;
var i:integer;
begin
 result := false;
 if @pInit <> nil then pInit(fsizex,fsizey,pchar(fparam),@result);
 finit := result;
 if result then
 begin
   SetContrast(fcontrast);
   SetBrightness(fbrightness);
   SetBackLight(fbacklight);
   fposx := -1;
   fposy := -1;

     for I := 0 to 7 do
      if @pCustomCharIndex <> nil then
       fcustomchar[i] := chr(pCustomCharIndex(i+1))
      else
       fcustomchar[i] := defCustomChar[i];
 end;
end;

procedure TArtLCD.SetBacklight(b:boolean);
begin
  fBackLight := b;
  if not finit then exit;
  if @pSetBacklight <> nil then
   pSetBacklight(b);
end;

procedure TArtLCD.SetContrast(b:byte);
begin
  fContrast := b;
  if not finit then exit;
  if @pSetContrast <> nil then
   pSetContrast(b);
end;

procedure TArtLCD.SetBrightness(b:byte);
begin
  fBrightness := b;
  if not finit then exit;
  if @pSetBrightness <> nil then
   pSetBrightness(b);
end;

procedure TArtLCD.Write(s:string);
begin
  if not finit then exit;
  if @pWrite <> nil then pWrite(pchar(s));
end;

procedure TArtLCD.WriteXY(x,y:byte;s:string);
begin
  SetPosition(x,y);
  Write(s);
end;

procedure TArtLCD.SetPosition(x,y:integer);
begin
  if x<0 then x:=0;
  if y<0 then y:=0;

  if (fposx=x) and (fposy=y) then exit;
  
  fposx := x;
  fposy := y;
  if not finit then exit;
  if @pSetPosition <> nil then
   pSetPosition(x+1,y+1);
end;

procedure TArtLCD.SetCustomChar(const char:byte; bitmap : TCharBitmap);
begin
  if not finit then exit;
  if @pCustomChar <> nil then
    pCustomChar(char+1, bitmap);
end;

function TArtLCD.ReadKey : char;
var x : word;
begin
  result := #0;
  if not finit then exit;
  if @pReadKey <> nil then
  begin
    x := pReadKey;
    if (x and $ff00) = $ff00 then EArtLCDException.Create('No key');
    result := chr(Lo(x));
  end
  else
   raise EArtLCDException.Create('No key');
end;

procedure TArtLCD.SetGPO(GPO : byte; GPOOn : boolean);
begin
 if not finit then exit;
 if @pSetGPO <> nil then
  pSetGPO(gpo, gpoon);
end;

procedure TArtLCD.SetFan(T1,T2 : byte);
begin
  if not finit then exit;
  if @pSetFan <> nil then
   pSetFan(t1,t2);
end;

procedure TArtLCD.Done;
begin
  if not finit then exit;
  if @pDone <> nil then
   pDone;
end;

procedure TArtLCD.SetPosX(x:integer);
begin
 if not finit then exit;
 SetPosition(x,fposy);
end;

procedure TArtLCD.SetPosY(y:integer);
begin
 if not finit then exit;
 SetPosition(fposx,y);
end;

procedure Register;
begin
  RegisterComponents('Art', [TArtLCD]);
end;

end.

